




/**
 ******************************************************************************
 *
 * @file        MCU.c
 * @brief       The mcu Code's c file.
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.01
 * @date        2023/06/14
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32x02z.h"
#include "MG32x02z_ChipInit.h"
#include "MG32x02z_Global.h"
#include "MG32x02z_USB.h"
#include "MG32x02z_USB_DRV.h"
#include "MG32x02z_PW_DRV.h"
#include "MG32x02z_TM_DRV.h"
#include "MG32x02z_USBD_API.h"
#include "MG32x02z_USBD_Keyboard_API.h"
#include "MG32x02z_CFG.h"
#include "MG32x02z_RGB_API.h"
#include "MG32x02z_USBD_EasyCOM_API.h"
#include "MG32x02z_USBD_EasyHID_API.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
static uint8_t MCU_ScheduleCnt;

uint8_t EasyCOM_Flag;

/* Private function prototypes -----------------------------------------------*/
void TM10_IRQHandler(void);
void MCU_Init(void);

/**
 *******************************************************************************
 * @brief	    TM0x IRQ handler function
 * @details     
 * @return      
 * @exception   No
 * @note        No
 *******************************************************************************
 */
void TM10_IRQHandler(void)
{

    TM_ClearFlag( TM10 , TMx_TOF);
    
    switch(MCU_ScheduleCnt)
    {
        case 0:
                KB.Scan_Flag_Start = 1;
                break;
        #if MG32x02z_USBD_KEYBOARD_RGB_EN != API_RGB_DISABLE
        case 6: 
                RGB_IRQHandler();
                break;
        #endif
        case 9:
                EasyCOM_Flag = 1;
                break;
        default: 
                break;
    }
    
    
    MCU_ScheduleCnt = MCU_ScheduleCnt + 1;
    
    if(MCU_ScheduleCnt>9)
    {
        MCU_ScheduleCnt = 0;
    }

}
/**
 *******************************************************************************
 * @brief	    MCU initial.
 * @details     
 * @return      
 * @exception   No
 * @note        No
 *******************************************************************************
 */
void MCU_Init(void)
{
    TM_TimeBaseInitTypeDef  MCU_TimeBase;
    
    /*CSC & GPIO Initial.*/
    ChipInit();
    
    /*Keyboard Releated Initial*/
    API_KB_Init();
    
    /*COM Releated Inital*/
    API_COM_Init();
    
    /*Easy HID Parameter Initial.*/
    API_HID_Init();
    
    /*USB Releated Initial*/
    //USB Power Control Related
    UnProtectModuleReg(PWprotect);
    PW_PeriphSLEEPModeContinuous_Config(PW_SLPPO_USB,ENABLE);
    PW_PeriphSTOPModeWakeUp_Config( PW_WKSTP_USB , ENABLE);
    ProtectModuleReg(PWprotect);
    
    //USB Module Inital.
    API_USBD_Init();
    NVIC_SetPriority(USB_IRQn,1);

    /*LED Initial*/
    #if MG32x02z_USBD_KEYBOARD_RGB_EN != API_RGB_DISABLE
        API_RGB_Init();
    #endif
    
    /*Time control*/
    MCU_ScheduleCnt = 0;
    EasyCOM_Flag    = 0;
    
    TM_DeInit(TM10);
    TM_TimeBaseStruct_Init(&MCU_TimeBase);
    MCU_TimeBase.TM_MainClockSource    = TM_CK_INT;
    MCU_TimeBase.TM_MainClockDirection = TM_DownCount;
    MCU_TimeBase.TM_Period             = 48-1; 
    MCU_TimeBase.TM_Prescaler          = 100-1;
    MCU_TimeBase.TM_CounterMode        = Cascade;
    TM_TimeBase_Init(TM10, &MCU_TimeBase);
    

    TM_ClearFlag(TM10 , TMx_TOF);
    TM_IT_Config(TM10 , TMx_TIE_IE , ENABLE);
    TM_ITEA_Cmd( TM10 , ENABLE);
    NVIC_EnableIRQ( TM10_IRQn);
    TM_Timer_Cmd(TM10 , ENABLE);
    
}








